﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.Threading.Tasks;
using UnityEngine;

public static class Constants
{
    #region Enums
    public enum Settings
    {
        MusicVolume,
        SFXVolume
    }

    public enum GameState
    {
        Running,
        Paused
    }

    public enum InputState
    {
        MouseAndKeyboard,
        Controller
    }

    public enum PlayerRole
    {
        Hider,
        Seeker
    }

    public enum Difficulties
    {
        Easy,
        Medium,
        Hard
    }

    public enum CharacterLegendType
    {
        Hide,
        Unhide,
        None
    }
    #endregion

    //Paths
    public static string SettingsXMLFilePath = Application.persistentDataPath + @"/Settings.xml";

    //Tags
    public const string HidableTag = "Hidable";
    public const string PCControlTag = "PCControl";
}
